
' Wizball - source code
'
' Coding,Music & Graphics: Paul Johnson
'
'
' Found on a cracked copy of the game by 007
'
' Imaged up by Mug U.K(tm) from a disk in the 'Uncle Harry' project.
'
'
' Released on Atari Legend site with the hope that some of the scene's coders, graphics artists and especially
' the musicians can breathe some life into this and improve the game so that it resembles the much superior
' C64 version.
'
' The original C64 (from memory) displayed the paint pots in the bottom border, plus had those haunting Martin Galway tunes.

' 
' More info on the C64 version can be found at:
'
'
' Simple updates:
' Make it system friendly so that it will run on all Atari's (ST through to TT & Falcon) and use STE specific 
' functions if necessary for better music replay (tracker mods possible?)


;0= WIZ
;1= CAT
;2=
;3=	
;6= SCORE
;7= TUBING
;8-15= BACKGROUND OBJECTS

CODE=$58000
ORG code
LOAD code
BRA.L START
EVEN

expand :EQU  $80000
sprites:EQU  $40000
palette:EQU  sprites-32
ainit:	EQU  $A000
atext:	EQU  $A008
mpos:	EQU  $26E0
mbut:	EQU  $26E7
phys: 	DC.L $78000
log:	DC.L $60000
phys2:	DC.L $70000
OJOYVECT:DC.L 0
VECTOR:DC.L 0
PALREG:	EQU $FF8240

	;    BACK  ,CAT   ,WIZ   
SRCE:	DC.L $48000,$40078,$412C0
	;    PEARL ,TRANS ,TRANS ,TRANS ,TRANS ,SPACE, POD
	DC.L $43200,$41C78,$41C70,$41C68,$41C60,$41C28,$41C20
	;    GLOB ANIMATION 10-13	  DROPLETS 14-17
	DC.L $28508,$28D28,$29548,$28D28,$285C8,$28DE8,$29608,$28DE8
	;    SPLASH 18-19
	DC.L $29E28,$2A648 
     BLK SRCE+128-* ;chars 32-55 miscellaneous items
	;    SLAPUP,SLAPDN,LOGO  ,HORIZON,SCENE,ICONS ,TUBE  
	DC.L $41C88,$41CA0,$450A0,$40000,$30000,$46360,$40008
     	;    SCORE
	DC.L $28000
     BLK SRCE+224-* ;chars 56-63 are background
	DC.L $0,$F00,$1E00,$2D00,$3C00,$4B00,$5A00,$6900
     BLK SRCE+256-*
WID:	DC.L 7,3,3
	DC.L 3,3,3,3,3,3,3
	DC.L 3,3,3,3,3,3,3,3
	DC.L 3,3
     BLK WID+128-*
	DC.L 3,3,35,3,100,55,3
	DC.L 3
     BLK WID+224-*
	DC.L 7,7,7,7,7,7,7
BLK WID+256-*
HEI: 	DC.L 199,10,14
	DC.L 14,14,15,15,16,16,16
	DC.L 12,12,12,12,12,12,12,12
	DC.L 12,12
     BLK HEI+128-*
	DC.L 10,10,25,24,71,24,24
	DC.L 6
     BLK HEI+224-*
	DC.L 23,23,23,23,23,23,23
BLK HEI+256-*
MASK:	DC.L $0,$40098,$41340
	DC.L $43208,$42718,$42710,$42708,$42700,$426C8,$426C0
	DC.L $28500,$28D20,$29540,$28D20,$285C0,$28DE0,$29600,$28DE0
	DC.L $29E20,$2A640 
     BLK MASK+128-*
	DC.L $42368,$42380,FF,FF,FF,FF,FF
	DC.L $28050 
     BLK MASK+224-*
	DC.L 0,0,0,0,0,0,0
BLK MASK+256-*
BACKS:	BLK.L 32,$FFFFFFFF
BACKW: 	BLK.L 32,3
BACKH:	BLK.L 32,15
BACKCOP:BLK.L 96,$FFFFFFFF
BULA:	BLK.L 8,-1
BULC:	BLK.L 8,0
ICONST:	DC.L 0
SVSP:	DC.L 0
TPTR:   DC.L 0
TPTR2:	DC.L 0
TSTART: DC.L 0
TSTART2:DC.L 0
RANVAL:	DC.L $12345678
EDGE:	DC.L 1
DETECT1:DC.L 0
DETECT2:DC.L 0
DETECT3:DC.L 0	
DETECT4:DC.L 0
DETECT5:DC.L 0
MAPREAD:DC.L 0 ;CURRENT MAP
MAPOFSET:DC.L LEVEL1,LEVEL2,LEVEL1,LEVEL2
TARGETI:DC.L 0 ;ICON TO DISPLAY AFTER FLIP
FLIPST:DC.L 0 ;ADDRESS OF FLIPPING ICON
FLIPI:DC.L 0 ;CURRENT SPRITE DURING FLIP
PICTURE:DC.L $30000,$32D00,$30000,$32D00

X:	BLK.W 16,0
Y:	BLK.W 16,0
C:	BLK.W 16,$FFFF
XDRCT:	BLK.W 16,0
YDRCT:	BLK.W 16,0
POSITION:BLK.W 16,0
SUBWAVES:DC.W 0
BADTYPE:DC.W 0
SUCKCNTR:DC.W 0
READER:DC.W 0
SCORFLG :DC.W 0
CATLIVES:DC.W 0
WORK:DC.W 1
TUBECNT:DC.W 0
LAST:	DC.W 0	;LAST DIRN FIRED BY WIZ
CLAST:	DC.W 0  ;LAST BY CAT
FIREDRN:DC.W 0	;CURRENT FIRE DIRECTION
CFIREDRN:DC.W 0 ;CAT FIREDRN
BADCNT: DC.W 0	;BADDIES LEFT IN A WAVE
FIRETIM:DC.W 0	;TIME SINCE LAST SHOT
OPOSITION:DC.W 0
NUPOSITION:DC.W 0
OY:	DC.W 0
OHEIGHT:DC.W 0
LIVES:	DC.W 0
LEVEL:	DC.W 0
EVEN
BULX:	BLK.W 8,0
BULY:	BLK.W 8,0
BULXD:	BLK.W 8,0
BULYD:  BLK.W 8,0
BBACK:	BLK.L 8,-1	
OBBACK:	BLK.L 8,-1	
BULR:	BLK.W 8,0
FIN:	DC.W 0	;AS ALWAYS
ANIMATE:DC.W 3	;COUNTER TO TIME ANIMATION OF SPRITES
HEIGHT:	DC.W 0	;HEIGHT OF WIZBALL (*2)
ROLL:	DC.W 0	
CNTR:	DC.W 1
TEMP:	DC.W 1
FF:     BLK.W $1400,$FFFF
SYNC:	DC.W 0
SPIN:	DC.W 0
SPINLO: DC.W 0
OSPINLO: DC.W 0
SPEED:	DC.W 0
ROTATE: DC.W 0
ICONNO:	DC.W 0
WAGCNT: DC.W 0	;COUNTS WAGGLES
WAGNO:	DC.W 0	;Do.
BUTTON:	DC.W 0	;TIMES FIRE BUTTON PRESS
FLIPC:DC.W 0	;ICON FLIPCNT
GREYCOL:DC.W $000,$222,$111,$555,$222,$333,$444,$555
	DC.W $666,$444,$444,$666,$333,$333,$333,$777
TITCOL:	DC.W $000,$400,$300,$654,$023,$333,$056,$555
	DC.W $461,$540,$150,$670,$040,$236,$500,$777
TARGET: DC.W 0,$411,$513,$755
	DC.W 0,$410,$530,$764
ZEROS:	BLK.W 16,0
CURRENT:BLK.W 16,0

DMASK:DC.W $5555,$1111,$0101,$0001 ;USED FOR RES & DERES
NOTES:	dc.w 3822,3608,3405,3214,3034,2863,2703,2551,2408,2273,2145,2025
	dc.w 1911,1804,1703,1607,1517,1432,1351,1276,1204,1136,1073,1012
	dc.w 956,902,851,804,758,716,676,638,602,568,536,506
	dc.w 478,451,426,402,379,358,338,319,301,284,268,253
	dc.w 239,225,213,201,190,179,169,159,150,142,134,127
	dc.w 119,113,106,100,95,89,84,80,75,71,67,63
	dc.w 60,56,53,50,47,45,42,40,38,36,34,32
	dc.w 30,28,27,25,24,22,21,20,19,18,17,16

player1:BLK.B 7,48
	DC.B 0
player2:BLK.B 7,48
	DC.B 0

MAP:
LEVEL1:	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 1,2,2,3
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,1,2,3
	DC.B 0,0,0,0
	DC.B 0,0,0,5
	DC.B 4,0,0,134
	DC.B 0,0,0,7
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,1
	DC.B 0,8,2,3
	DC.B 0,0,0,0
	DC.B 0,0,0,5
	DC.B 4,0,0,134
	DC.B 0,0,0,7
	DC.B 0,0,0,0
	DC.B 0,0,1,3
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,1,3
	DC.B 0,0,0,0
	DC.B 0,0,0,5
	DC.B 4,0,0,134
	DC.B 0,0,0,7
	DC.B 0,0,0,0
	DC.B 1,2,2,3
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	
LEVEL2:	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,132
	DC.B 0,0,0,3
	DC.B 0,0,0,0
	DC.B 0,0,130,8
	DC.B 0,0,6,0
	DC.B 0,1,7,5
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 1,0,130,8
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,3
	DC.B 0,0,0,132
	DC.B 0,0,0,0
	DC.B 0,1,5,5
	DC.B 0,1,0,0
	DC.B 0,1,5,5
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,7
	DC.B 0,7,5,7
	DC.B 0,6,0,6
	DC.B 5,7,5,7
	DC.B 0,0,0,0
	DC.B 0,0,0,0
	DC.B 0,0,0,0

ICON:	DC.B 0 ;FILLER
ITHRUST:DC.B 2
IFIRE:	DC.B 2	
ICAT:	DC.B 1
IBLAZ:	DC.B 1
ISPRAY:	DC.B 4
IBOMB:	DC.B 16
ISHIELD:DC.B 16
IINIT:DC.B 0,2,2,1,1,4,16,16
PIT1:DC.B 0
PIT2:DC.B 0
PIT3:DC.B 0
PRIORTIM:DC.B 0
XTR :DC.B 0
OXTR:DC.B 0
JOYPORT0:DC.B 0
JOYPORT1:DC.B 0,0,0	
SUPERUSER:DC.B 1
TUNFLG:	DC.B 0

PRIORITY:DC.B 0
TIMER:	DC.B 0
TIMER2: DC.B 0

SONCNTR: DC.B 0

; sounds are preceded by PRIORITY and PRIORTIM values.

E1:	DC.B 5,4,  0,$40, 1,1, 2,$38, 3,1, 8,16, 9,16, 12,20, 13,0, 11,20
	DC.B 7,%11111100, $FF,0 ;PEARL CAUGHT
E2:	DC.B 5,4,  0,$40, 1,0, 2,$78, 3,0, 8,16, 9,16, 12,20, 13,0, 11,20
	DC.B 7,%11111100, $FF,0 ;ICON SELECTED
E99:	DC.B 5,4,  0,$56, 1,0, 2,$56, 3,0, 8,16, 9,15, 12,1
	DC.B 13,10, 11,50, 7,%11111100, $80,16, $81,9,-1,0
	DC.B $FF,0,8,0, $FF,0 ;brikhit
E3:	DC.B 5,8, 0,2, 1,15, 2,2, 3,15, 8,16, 9,16, 12,20, 13,10,
	DC.B 11,20, 7,%11111100 
	DC.B $80,240, $81,1,-16,0,  $FF,10, 8,0, 9,0, $FF,0 ;BOUNCE
E4:	DC.B 40,3,  0,2, 1,0, 2,2, 3,16, 8,13, 9,13, 7,%11110100 
	DC.B $80,15, $81,6,-1,0,  $FF,5, 8,5, 9,5, $FF,0 ;ZAP
E5:	DC.B 40,3,  0,0, 1,15, 8,15, 12,0, 13,4, 11,20, 7,%11111110
	DC.B $80,0, $81,1,1,15,  $FF,1, 8,0, $FF,0 ;FIRE
E6:	DC.B 5,4,  0,8, 1,2, 2,12, 3,4, 8,16, 9,16, 12,20, 13,9
	DC.B 11,20, 7,%11111100 
	DC.B $80,200, $81,0,-20,0,  $FF,1, 8,0, 9,0, $FF,0 ;BOUNCE OBJECT
E7:	DC.B 100,50,  0,0, 1,0, 8,16, 12,70, 13,0, 11,20, 7,%11111110
	DC.B $80,0, $81,1,1,255,  $FF,0 ;DEAD
E8:	DC.B 250,15,  0,100, 1,4, 2,101, 3,4, 8,15, 9,15
	DC.B 11,0, 12,30, 7,%11111100
	DC.B $FF,5, 1,3, 3,3, $FF,5, 1,2, 3,2, $FF,5, 1,1, 3,1, 
	DC.B $FF,5, 1,0, 3,0
	DC.B $FF,5, 13,0, 8,16, 9,16, $FF,0 ;XTRA
E9:	DC.B 30,10,  0,8, 1,2, 8,16, 12,25, 13,9, 11,20, 7,%11111110 
	DC.B $80,0, $81,1,1,15,  $80,0, $81,1,1,15, $FF,50
	DC.B 8,0, 9,0, $FF,0 ;BADHIT
E10:	DC.B 5,5, 0,32, 1,0, 2,80, 3,0, 8,15, 9,16, 12,1
	DC.B 13,10, 11,100, 7,%11111100, $80,16, $81,8,-1,0
	DC.B $FF,12,9,0, $FF,0
E11:	DC.B 5,5, 0,20, 1,0, 2,48, 3,0, 8,15, 9,16, 12,1
	DC.B 13,10, 11,50, 7,%11111100, $80,16, $81,8,-1,0
	DC.B $FF,10,9,0, $FF,0 ; FACEHIT
E12:	DC.B 105,5, 0,27, 1,0, 2,48, 3,0, 8,16, 9,16, 12,10
	DC.B 13,10, 11,0, 6,30, 7,%11111100, $FF,40 
	DC.B $80,15, $81,8,-1,0, 7,%11110100,
	DC.B $FF,10,9,0, $FF,0 ; FADER
E13:	DC.B 200,1, 0,100, 1,5, 2,80, 3,1, 8,15, 11,0, 12,70, 7,%11110110
	DC.B $80,0, $81,6,1,31, $FF,3, 12,40, 13,0, 8,16,$FF,0 ;DERES
E14:	DC.B 200,1, 0,100, 1,5, 2,80, 3,1, 8,15, 11,0, 12,70, 7,%11110110
	DC.B $80,31, $81,6,-1,0, $FF,3, 12,40, 13,0, 8,16,$FF,0 ;RES
E15:	DC.B 200,1, 1,0, 8,16, 13,14, 11,0, 12,10
	DC.B 7,%11111110, $80,70, $81,0,-2,50
	DC.B $80,50, $81,0,2,100, 8,0, $FF,0

T0:	DC.B 5,0, 8,0, 9,0, 10,0, 11,20, 12,30, 7,%11111000, $FF,0
T1:	DC.B 5,0, 0
 tpitchl:DC.B 100, 1
 tpitchh:DC.B 0, 8
 tenv:	DC.B 16
T2:	DC.B 2
 tpitchl2:DC.B 100, 3
 tpitchh2:DC.B 0, 9
 tenv2:	DC.B 16
T3:	DC.B 4
 tpitchl3:DC.B 100,5
 tpitchh3:DC.B 0, 10
 tenv3: DC.B 16, 13,9, 11,20, 12,20, 7,%11111000, $FF,0
TE:	DC.B 5,0, 8,0, 9,0, 10,0, 7,255, $FF,0
SEQ:	DC.B 5,5,  0,0, 1,0, 8,16, 12,70, 13,0, 11,20, 7,%11111110
	DC.B $80,0, $81,1,3,255,  $FF,0	
EVEN
T:
START:	MOVE SR,D0
	CMP #$22FF,D0
	BGT.S OKSUP
	BSR.L super
OKSUP:	MOVE.B #6,$484 ;KEYCLICK OFF- SHIFT USED
	BSR.L SETINT
NUGAME:	BSR.L initscrn
	BSR.L initjoy
	BSR.L dark

;	LEA TITLEPIC,A0
;	BSR load
	MOVE.L #$50000,A0
	MOVE.L #$78000,A1
	BSR.L copy

	TST WORK
	BEQ TITPASS

	LEA GREYCOL+2,A1
	BSR FADEIN
	
	MOVE #25,D0
	BSR.L WAIT	
	LEA PALREG+2,A0
	LEA TITCOL+2,A1

TRAND:	BSR.L randsub
	BSR.L randsub
	AND #3,D0
	BEQ.S TMOD
	CMP #1,D0
	BEQ.L TMOD2
	CMP #2,D0
	BEQ.L TFLICK
	CMP #3,D0
	BEQ.S TFLASH
	CMP #4,D0
	BEQ TRAND
	
STRIPE:	MOVE #14,D1
TIT22:	MOVE (A1)+,D7
	MOVE #6,D6
TIT2:	BSR.L randsub
	AND #$777,D0
	MOVE D0,(A0)
	CMP.W D0,D7
	BNE.S TIT2
	DBRA D6,TIT2
	ADDQ #2,A0
	DBRA D1,TIT22
	BRA.L TITJN

TFLASH:	BSR.L randsub
	MOVE D0,D2
	OR #$444,D2
	MOVE #14,D1
TITC:	MOVE D2,(A0);SET PALREG TO RANDOM NO.
	BSR.L owvbl
	BSR.L owvbl
	MOVE #$777,(A0)
	BSR.L owvbl
	BSR.L owvbl
	MOVE (A1)+,(A0)+; SET PALREG TO TARGET COLOUR
	DBRA D1,TITC
	BRA.L TITJN

TMOD:	MOVE #14,D7
TITM:	MOVE #2,D6
TITM2:	BSR.L OWVBL
	BSR.S MODIFY
	DBRA D6,TITM2
	ADDQ #2,A0
	ADDQ #2,A1
	DBRA D7,TITM
	BRA.L TITJN

TMOD2:	MOVE #2,D6
TIT3:	LEA PALREG+2,A0
	LEA TITCOL+2,A1
	MOVE #14,D7
TIT32:	BSR.L OWVBL
	BSR.S MODIFY
	ADDQ #2,A0
	ADDQ #2,A1
	DBRA D7,TIT32
	MOVE #20,D0
	BSR.L WAIT
	DBRA D6,TIT3
	BRA.L TITJN

TFLICK:	MOVE #16,D1
TFLKLP:	BSR.L GREY
	MOVE D1,D0
	BSR.L WAIT
	BSR.L COLOUR
	MOVE #16,D0
	SUB D1,D0
	BSR.L WAIT
	SUBQ #2,D1
	BNE.S TFLKLP
	BRA.S TITJN

MODIFY:	MOVE (A0),D0 ;PALREG
	MOVE (A1),D1 ;TARGET
	MOVE D0,D4 ;NEW COL
	MOVE D0,D2
	MOVE D1,D3
	AND #$7,D2
	AND #$7,D3
	CMP D2,D3
	BEQ.S MOK1
	BMI.S MDN1
	ADDQ #1,D4
	BRA.S MOK1
 MDN1:	SUBQ #1,D4
 MOK1:	MOVE D0,D2
	MOVE D1,D3
	AND #$70,D2
	AND #$70,D3
	CMP D2,D3
	BEQ.S MOK2
	BMI.S MDN2
	ADD #$10,D4
	BRA.S MOK2
 MDN2:	SUB #$10,D4
 MOK2:	MOVE D0,D2
	MOVE D1,D3
	AND #$700,D2
	AND #$700,D3
	CMP D2,D3
	BEQ.S MOK3
	BMI.S MDN3
	ADD #$100,D4
	BRA.S MOK3
 MDN3:	SUB #$100,D4
 MOK3:	MOVE D4,(A0)
	RTS

copy:	MOVE.W #$1F40,D0
CPLOOP: MOVE.L (A0)+,(A1)+
	DBRA D0,CPLOOP
	RTS	

TITJN:	BSR.L colour

TITWAIT:BTST #7,JOYPORT1
	BEQ.S TITWAIT
TITPASS:MOVE #-1,LEVEL
	MOVE #6,D0
	LEA player1,A0
PLAYLP:	MOVE.B #48,8(A0)
	MOVE.B #48,(A0)+
	DBRA D0,PLAYLP
	BSR NEWLEVEL
	MOVE #3,LIVES
	BRA NULIFE

NULEVEL:BSR NEWLEVEL
	BSR FIRSTPRNT
	MOVE.L #$78000,phys	
	MOVE.L #$38000,A0
	MOVE.L #$78000,A1
	BSR.L copy
	LEA CURRENT+2,A1
	BSR FADEIN
	MOVE #28,TUBECNT
	MOVE.L #0,HEI+152
	MOVE.L #$410F8,SRCE+152
	MOVE #38,C+14
	MOVE #160,X+14
	MOVE #54,Y+14
	BRA ALWAYS

NEWLEVEL:MOVE #15,D0
	LEA palette,A1
	MOVE.L #CURRENT,A0
CURRSET:MOVE (A1)+,(A0)+	
	DBRA D0,CURRSET


	MOVE LEVEL,D0
	ADDQ #1,D0
	AND.L #1,D0
	MOVE D0,LEVEL	
	ASL #2,D0
	LEA MAPOFSET,A5
	MOVE.L (A5,D0.W),D0
	MOVE.L D0,MAPREAD

	MOVE LEVEL,D0
	ASL #2,D0
	LEA PICTURE,A0
	MOVE.L (A0,D0.W),SRCE+144

	MOVE.W #$8000,D0
	MOVE.L #expand,A0
	MOVE.L A0,phys
BPLOOP: CLR.L (A0)+
	DBRA D0,BPLOOP

	CLR C
	CLR X
	CLR Y
	CLR.L D6
	MOVE LEVEL,D6
	ASL #4,D6
	ADD.L #$48000,D6
	MOVE.L D6,SRCE
	MOVE #3,D6
EXPLP16:MOVE #3,D7
EXPLP4:	BSR.L rprnt
	ADD #49,X
	DBRA D7,EXPLP4
	ADD.L #$8000,phys
	MOVE X,D0
	AND #15,D0
	MOVE D0,X
	DBRA D6,EXPLP16
	RTS

NULIFE:	CLR ICONNO
	MOVE #7,D0
	LEA ICON,A0
	LEA IINIT,A1
ICSET:	MOVE.B (A1)+,(A0)+
	DBRA D0,ICSET
	MOVE.L #$79228,ICONST
	MOVE.L #$38000,phys
	MOVE #48,X
	MOVE #29,Y
	MOVE #37,C
	BSR PRNT0 ;ICON STRIP
	BSR FIRSTPRNT
	BSR light
	MOVE.l #$78000,phys
	BSR SETSCRN
	BSR.L deres
	MOVE.L #$38000,A0
	MOVE.L #$78000,A1
	BSR.L copy
	MOVE #9,CATLIVES
	MOVE #8,BADCNT
	MOVE #10,BADTYPE
	CLR SUBWAVES
	BRA ALWAYS

FIRSTPRNT:BSR.L initscrn
	MOVE.L #$38000,phys
	LEA BACKS,A0	
	MOVE #380,D0
NOBACKS:MOVE.W #-1,(A0)+
	DBRA D0,NOBACKS	
	LEA BBACK,A0
	LEA BULA,A1
	LEA BULX,A2
	MOVE #15,D0
NOBBAK:	MOVE.L #-1,(A0)+
	MOVE.W #-1,(A1)+
	MOVE.W #-1,(A2)+
	DBRA D0,NOBBAK
	BSR prepare
	CLR.B PRIORTIM
	MOVE #60, POSITION
	MOVE POSITION,NUPOSITION
	MOVE POSITION,OPOSITION
	MOVE POSITION,D0
	AND #15,D0
	MOVE D0,ROTATE
	BSR.L BACKLINE	
	BSR.L objects	
	BSR.L edges
	RTS

ALWAYS:	bsr.L light
	MOVE.L #$70000,A1
	MOVE.L #$38000,A0
	BSR.L copy
	BSR prepare
	MOVE.l #$78000,phys
	LEA Y+16,A0
	LEA YDRCT+16,a1
	MOVE BADCNT,D0
	SUBQ #1,D0
	BMI NOBADS
SETBADLP:MOVE.w BADTYPE,32(A0);C
	MOVE.W #90,(A0)+;Y
	CLR.w (A1)+
	DBRA D0,SETBADLP

	MOVE #260,POSITION+16
	MOVE #200,POSITION+18
	MOVE #460,POSITION+20
	MOVE #480,POSITION+22
	MOVE #560,POSITION+24
	MOVE #680,POSITION+26
	MOVE #470,POSITION+28
	MOVE #464,POSITION+30
NOBADS:
	MOVE #34,C
	MOVE #84,X
	MOVE #0,Y
	BSR.L prnt0; sparkle logo

	MOVE #1,C+2; CAT
	CLR X+2
	MOVE #40,Y+2
	MOVE #2,C; wizball
	MOVE.L #14,HEI+8
	MOVE #160,X
	MOVE #66,Y
	MOVE #66*4,HEIGHT	
	CLR YDRCT
	CLR SPIN
	CLR SPEED
	CLR FLIPC
	CLR ROLL
	CLR SPINLO
	CLR FIN
	CLR WAGCNT
	CLR WAGNO
	CLR FIRETIM
	CLR SCORFLG
	MOVE #1,FIREDRN
	BSR scoreset
	TST ICONNO
	BEQ LOOPER
	BSR IFLASH
	
LOOPER:	bsr.L owvbl
	SUBQ.B #1,PRIORTIM
	BPL.S TIMYES
	CLR.B PRIORTIM
TIMYES:	BSR.L swapscrn
	BSR scoreprnt
	BSR TUBEREP
	BSR.L wizreplace
	BSR.L replacer
	BSR.L replace
	BSR.L breplace
	MOVE POSITION,D0
	MOVE D0,OPOSITION
	ADD SPEED,D0
	BPL.S POSNMI
	CLR SPEED
	CLR D0
POSNMI:	CMP #$4F0,D0
	BMI.S POSOK
	MOVE #$4F0,D0
	CLR SPEED
POSOK:	MOVE D0,POSITION
	MOVE D0,NUPOSITION
	AND #15,D0
	MOVE D0,ROTATE
	BSR.L BACKLINE	
	BSR TUBE
	BSR.L wiz
	BSR.L BULLETS
	BSR.L objects	
	BSR.L bprnt; print bullets
	BSR.L owvbl
	BSR.L wizprnt
	BSR.L baddies
	BSR.L edges
	BSR.L FLIP
	BSR.L setscrn
	TST FIN
	BEQ.L NOFIN
	CMP #2,FIN
	BNE DEAD
	MOVE #14,SUCKCNTR
SUCKLP:	BSR swapscrn
	BSR owvbl
	BSR wizreplace
	BSR replace
	BSR replacer
	BSR breplace	
	BSR BACKLINE
	BSR objects
	ADDQ #1,Y
	SUBQ.L #1,HEI+8
	BSR prnt0
	BSR baddies
	BSR edges
	BSR setscrn
	BSR owvbl
	SUBQ #1,SUCKCNTR
	BNE SUCKLP
	BSR scoreset
;	CLR.L D0
;	MOVE LEVEL,D0
;	ASL #3,D0
;	ADD.L #TARGET+2,D0
;	MOVE.L D0,A3
;	MOVE (A3)+,CURRENT+2
;	LEA CURRENT+2,A1
;	BSR FADEIN
;	MOVE (A3)+,CURRENT+4
;	LEA CURRENT+2,A1
;	BSR FADEIN
;	MOVE (A3)+,CURRENT+6
;	LEA CURRENT+2,A1
;	BSR FADEIN

	LEA ZEROS+2,A1
	BSR FADEIN
	MOVE.L #$38000,A1
	MOVE.L #$70000,A0
	BSR.L copy
	BRA NULEVEL
DEAD:	BSR scoreset
	MOVE.L #$38000,A1
	MOVE.L #$70000,A0
	BSR.L copy
	BSR.L res
	BSR DARK
	SUBQ #1,LIVES
	BNE NULIFE
	JMP NUGAME
NOFIN:	BTST #7,JOYPORT0
	BEQ.L LOOPER
FLUSH:	MOVE.B JOYPORT1,D0
	TST.B D0
	BNE.S FLUSH
	BSR.L resmouse
	BSR.L owvbl
	BSR.L owvbl
	BSR.L owvbl
	BRA.L H

TUBE:	TST TUBECNT
	BEQ TUBERET
	SUBQ #1,TUBECNT
	BEQ TUBERET
	CMP #14,TUBECNT
	BCS TUBEUP
TUBEDN:	ADDQ.L #2,HEI+152
	SUB.L #$140,SRCE+152
	BRA TUBEJN
TUBEUP:	SUBQ.L #2,HEI+152
	ADD.L #$140,SRCE+152
TUBEJN:MOVE #7,D0
	BSR PRNT
TUBERET:RTS

TUBEREP:TST.L BACKS+28
	BMI TUBERET
	MOVE.L BACKS+28,A0 
	MOVE.L HEI+152,D0
	ADDQ #2,D0
TUBECLR:CLR.L (A0)+
	CLR.L (A0)
	LEA $9C(A0),A0
	DBRA D0,TUBECLR
	MOVE.L #-1,BACKS+28
	RTS

objects:MOVE ROTATE,D0
	EOR #15,D0
	MOVE D0,D5 
	AND.L #12,D5
	SWAP D5
	LSR.L #3,D5
	MOVE.L D5,A6
	AND.L #3,D0
	ASL #3,D0
	ADD D0,A6
	ASL #1,D0
	ADD D0,A6
	ADD.L #expand,a6 ;start of shifted sprite data

	MOVE.L phys,A5
	ADD #$2760,A5
	LEA BACKS+64,A3

	MOVE NUPOSITION,D2
	MOVE D2,D0
	AND #16,D0
	LSR #1,D0
	SUB D0,A5
	AND #-31,D2
	LSR #3,D2
	MOVE D2,READER
	CLR.L D6
	MOVE.L MAPREAD,A4
	MOVE #9,D6
HPLOOP:	MOVE #3,D7
VPLOOP:	CLR D0
	MOVE.B (A4,D2.W),D0; read map
	BEQ.S NOBJ	 
	AND #15,D0 ;FILTER EXTRAS
	ADD #55,D0 ;GET CHARACTER NO
	ASL #2,D0
	MOVE.L D0,A0
	ADD.L #SRCE,A0
	MOVE.L (A0),A1 ; SPRITE
	ADD.L A6,A1 ; ADD SHIFT
	MOVE.L A5,A0 ; SCREEN
	MOVE.L A5,(A3)+; STORE TO BACKS	
	MOVE.L #23,D4 ;HEIGHT
	
	PHLOOP:	MOVE.L (A1)+,D1
		MOVE.W (A1),D0; MASK
		EOR #-1,D0
		AND D0,2(A0)
		OR D1,2(A0)
		SWAP D1
		AND D0,(A0)
		OR D1,(A0)
		ADDQ #4,A1
		ADDQ #8,A0
	
		MOVE.L (A1)+,D1
		MOVE.W (A1),D0; MASK
		EOR #-1,D0
		AND D0,2(A0)
		OR D1,2(A0)
		SWAP D1
		AND D0,(A0)
		OR D1,(A0)
		ADDQ #4,A1
		ADDQ #8,A0
	
		MOVE.L (A1)+,D1
		MOVE.W (A1),D0; MASK
		EOR #-1,D0
		AND D0,2(A0)
		OR D1,2(A0)
		SWAP D1
		AND D0,(A0)
		OR D1,(A0)

		LEA $90(A0),A0
		LEA $8C(A1),A1
		DBRA D4,PHLOOP
	
NOBJ:	LEA $F00(A5),A5 ;UPDATE SCREEN ADDRESS
	ADDQ #1,D2 ; FETCH NEXT POSITION
	DBRA D7,VPLOOP	
	LEA -$3BF0(A5),A5
	DBRA D6,HPLOOP

BACKRST:CMP.L #BACKS+124,A3
	BCC.S BACKRST1
	MOVE.L #-1,(A3)+
	BRA.S BACKRST
BACKRST1:RTS

baddies:SUBQ #1,ANIMATE
	BNE.L NANIM
	MOVE #2,ANIMATE
	MOVE.L SRCE+36,D0 ;ANIMATE PODS
	ADDQ #8,D0
	CMP.L #$41C60,D0
	BCS.S NWRAPB
	MOVE.L #$41C20,D0
NWRAPB: MOVE.L D0,SRCE+36
	ADD #$AA0,D0
	MOVE.L D0,MASK+36 
	
	CMP #2,IFIRE
	BEQ.S NWRAPC2
	CMP.L #14,BACKH
	BEQ.S WRAPC
	MOVE.L SRCE+128,D0
	ADDQ #8,D0
	CMP.L #$41CA0,D0
	BCS.S NWRAPC
WRAPC:	MOVE.L #$41C80,D0
NWRAPC:	MOVE.L D0,SRCE+128
	ADD.L #$20,D0
	MOVE.L D0,SRCE+132
	ADD.L #$6E0,D0
	MOVE.L D0,MASK+132
	SUB.L #$20,D0
	MOVE.L D0,MASK+128
NWRAPC2:
	
	MOVE.L SRCE+4,D0
	ADDQ #8,D0
	CMP.L #$40098,D0
	BCS.S NWRAPD
	MOVE.L #$40078,D0
NWRAPD:	MOVE.L D0,SRCE+4

NANIM:	MOVE #7,D1
	MOVE #16,D2
	MOVE #32,D3
	LEA POSITION,A1
	LEA X,A2
	LEA BACKS,A3
BADDLP:	MOVE 64(A2,D2.w),D6
	TST D6
	BEQ.L NOAN
	CMP #9,D6
	BEQ.S NTRANS
	BCC BADMOVE
	CMP #3,D6
	BEQ.S NTRANS
	CMP #2,ANIMATE
	BNE.S NTRANS
	SUBQ #1,D6
	MOVE D6,64(A2,D2.W)
	BRA NTRANS
BADMOVE:MOVE 128(A2,D2.W),D0 ;YDRCT
	ADDQ #1,D0
	MOVE 32(A2,D2.W),D7 ;Y
	ADD D0,D7
	CMP #140,D7
	BCS NTRN1
	MOVE #140,D7
	NEG D0
	SUBQ #1,D0
NTRN1:	MOVE D0,128(A2,D2.W)
	MOVE D7,32(A2,D2.W)
	TST.W D0
	BPL NTRANS
	CMP #2,ANIMATE
	BNE NTRANS
	MOVE 64(A2,D2.W),D0
	ADDQ #1,D0
	CMP #14,D0
	BCS NTRN
	MOVE #10,D0
NTRN:	MOVE D0,64(A2,D2.W)	
NTRANS:	MOVE (A1,D2.W),D0 ;POSITION OF BADDY
	SUB NUPOSITION,D0 ;SUBTRACT SCREEN POSITION
	MOVE D0,(a2,d2.W) ;SET X CORD
	CMP #300,D0 ;CHECK ON-SCREEN
	BCC.L OFFCHK 
	SUB #146,D0
	CMP #28,D0
	BCC.L BADNWIZ
	MOVE 32(A2,D2.W),D0
	SUB Y,D0
	ADD #15,D0
	CMP #30,D0
	BCC.S BADNWIZ
	
	CLR 64(A2,D2.W) ;CLEAR C
	CMP #9,D6
	BCS.S ICONADD
	MOVE #9,64(A2,D2.W)	
	MOVE #1,FIN
	BRA.S BADNWIZ
ICONADD:BSR.L IREPL
	ADD.L #16,ICONST
	ADDQ #1,ICONNO
	CMP #8,ICONNO
	BCS IKOK
	MOVE #1,ICONNO
	MOVE.L #$79238,ICONST 
IKOK:	BSR.S IFLASH
	LEA PLAYER1+4,A0
	BSR score
	MOVE.L #E1,D7
	BSR.L son
deduct:	SUBQ #1,BADCNT
NWAVEND:BRA.S NOAN

BADNWIZ:MOVE D2,D0
	LSR #1,D0
	BSR.L PRNT
NNP:	ADDQ #2,D2
	ADDQ #4,D3
	DBRA D1,BADDLP
	RTS
OFFCHK:	CMP #9,D6
	BCC.S NOAN
	CLR 64(A2,D2.W)
	SUBQ #1,BADCNT
NOAN:	MOVE.L #-1,(A3,D3.W)
	BRA.S NNP

IFLASH:	MOVE.L ICONST,A0
	MOVE #22,D0
IFLP:	CLR.L (A0)+
	CLR.L (A0)+
	CLR.L (A0)+
	CLR.L (A0)+
	LEA $90(A0),A0
	DBRA D0,IFLP
	RTS

IPRNT:	MOVE.L FLIPST,D0
	AND.L #$7FFF,D0
	ADD.L phys,D0
	MOVE.L D0,A0
	BRA.S IRJN

IBOTH:	MOVE.L ICONST,D0
	EOR.L #$8000,D0
	MOVE.L D0,A0
	BSR.S IRJN

IREPL:	MOVE.L ICONST,A0
	MOVE.L A0,D0
	EOR.L #$8000,D0
	MOVE.L D0,A4
IRJN:	MOVE #22,D0
IRLP:	MOVE.L (A4)+,(A0)+
	MOVE.L (A4)+,(A0)+
	MOVE.L (A4)+,(A0)+
	MOVE.L (A4)+,(A0)+
	LEA $90(A0),A0
	LEA $90(A4),A4
	DBRA D0,IRLP
	RTS

edges:	MOVE.L phys,A0
	ADD #$24d8,A0
	MOVE #100,D0
edgelp:	CLR.L (A0)+
	CLR.L (A0)+
	CLR.L (A0)+
	CLR.L (A0)+
	LEA $90(A0),A0 
	DBRA D0,edgelp
	RTS

prepare:MOVE.L #$38000,phys
	MOVE.L #$3A120,A0
	MOVE #136*$20,D0
bwipe:	CLR.L (A0)+
	DBRA D0,BWIPE
	MOVE #16,X
	MOVE #35,C
	MOVE #139,Y
	MOVE #17,D5
GROUND:	BSR prnt0
	ADD #16,X
	DBRA D5,GROUND
	CLR X
	MOVE #67,Y
	MOVE #36,C
	BSR prnt0
	MOVE #3,SCORFLG
	BSR scoreprnt
	RTS

wiz:	CMP #14,TUBECNT
	BCC wizret
	ADDQ #1,WAGCNT
	TST SPIN
	BEQ.S SPINSAME
	BMI.S SPINEG
	MOVE #1,FIREDRN
	BRA.S SPINSAME ;SETS FIRE DIRECTION
SPINEG:	CLR FIREDRN
SPINSAME:MOVE SPINLO,OSPINLO
	MOVE.B JOYPORT1,D7
	TST.B ICAT
	BNE.S NCATCNT
	CMP #6,BUTTON
	BPL.S NEITHER
NCATCNT:BTST #2,D7
	BNE.S LEFT
	BTST #3,D7
	BNE.S RIGHT
NEITHER:TST.B ITHRUST
	BNE.S NOSPIN
	TST SPINLO
	BEQ.S NOSPIN
	BMI.S RIGHT
LEFT:	SUBQ #1,SPINLO
	CMP #-24,SPINLO
	BPL.S NOSPIN
	MOVE #-24,SPINLO
	BRA.S NOSPIN
RIGHT:	ADDQ #1,SPINLO
	CMP #24,SPINLO
	BMI.S NOSPIN
	MOVE #24,SPINLO
NOSPIN: MOVE SPINLO,D0
	ADD #24,D0
	LSR #2,D0
	SUBQ #6,D0
	MOVE D0,SPIN
	ADD ROLL,D0
	AND.L #63,D0
	MOVE D0,ROLL
	ASL #1,D0
	AND #248,D0
	ADD.L #$412C0,D0
	MOVE.L D0,SRCE+8

	MOVE Y,D1
	MOVE D1,OY
	CMP.B #2,ITHRUST
	BCC.S NSTEER
	MOVE SPIN,D0
	MOVE D0,SPEED

NSTEER:	TST.B ITHRUST
	BNE.S BONCE
	MOVE YDRCT,D2
	TST.B ICAT
	BNE.S STEER
	CMP #6,BUTTON
	BPL.S NEETHER	
STEER:	BTST #0,D7
	BNE.S UP
	BTST #1,D7
	BNE.S DOWN	
NEETHER:CMP.W #0,D2
	BEQ.S NDOWN
	BPL.S UP
DOWN:	ADDQ #1,D2
	CMP #6,D2
	BMI.S NDOWN
	MOVE #6,D2
	BRA.S NDOWN
UP:	SUBQ #1,D2	
	CMP #-6,D2
	BPL.S NDOWN
	MOVE #-6,D2
NDOWN:	MOVE D2,YDRCT
	ADD D2,D1
	CMP #58,D1
	BCC.S NUPL
	MOVE #58,D1
NUPL:	CMP #140,D1
	BCS.S NDOWNL
	MOVE #140,D1
NDOWNL:	MOVE D1,Y 	
	BRA.S WCHECK

BONCE:	MOVE YDRCT,D0
	ADDQ #1,D0
	MOVE HEIGHT,D1
	MOVE D1,OHEIGHT
	ADD D0,D1
	CMP #140*4,D1
	BCS.S NBOUNCE
	MOVE #140*4,D1
	MOVE #-25,D0
	MOVE SPIN,D2
	MOVE D2,SPEED
NBOUNCE:MOVE D0,YDRCT
	MOVE D1,HEIGHT
	LSR #2,D1
	MOVE D1,Y

WCHECK:	MOVE Y,D7
	MOVE X,D6
	BSR.L cord
	MOVE.L A0,BACKS
	MOVE.L (A0),DETECT1
	MOVE.L $280(A0),DETECT2
	MOVE.L $500(A0),DETECT3
	MOVE.L $780(A0),DETECT4
	MOVE.L $960(A0),DETECT5

	TST FIRETIM
	BEQ.S FTOK
	SUBQ #1,FIRETIM
FTOK:	BTST #7,JOYPORT1
	BEQ.L nfirebut	
	ADDQ #1,BUTTON
	TST FIRETIM
	BNE.L WIZNF 
	LEA BULX,A0
	MOVE #1,D0	
BULFND:	TST (A0)
	BMI.S BULF
	ADDQ #2,A0
	DBRA D0,BULFND
	BRA.S WIZNF
	
BULF:	MOVE #4,FIRETIM
BULFOUND:LEA X,A1
	MOVE 32(A1),D0 ;wizy 
	ADD #7,D0
	CMP #138,D0
	BCC wiznfire	
	MOVE D0,16(A0) ;y
	CLR 48(A0) ;ydrct
	MOVE.L #E5,D7
	BSR.L son
	MOVE (A1),D0 ;wizx
	ADDQ #6,D0
	MOVE D0,(A0)
	MOVE #10,32(A0)
	TST.B IFIRE
	BNE.S NBIDI; NOT BI-DIRECTIONAL
	MOVE LAST,D0
	EOR #1,D0
	MOVE D0,LAST
	BNE.S wiznjn
	BRA.S wiznfire
NBIDI:	MOVE FIREDRN,LAST
	TST FIREDRN
	BNE.S wiznfire
wiznjn:	NEG 32(A0)
	BRA.S wiznfire
wiznfire:

WIZNF:BRA WIZNF2	

nfirebut:CLR BUTTON
WIZNF2:	CMP #7,WAGNO
	BCS.L wiznsel
	TST ICONNO
	BEQ.L wiznsel
	LEA ICON,A0
	MOVE ICONNO,D0
	MOVE.B (A0,D0.W),D1
	TST.B D1
	BEQ.L wiznsel
	SUBQ.B #1,D1
	MOVE.B D1,(A0,D0.W)
	BNE.S NARROW
	CMP #1,D0
	BNE.S ICNT
	CLR YDRCT
 ICNT:	MOVE.L #$43B60,A4 ;ARROW CHARACTER
	MOVE.L #$43BA0,FLIPI 
	BRA.S ICJN
NARROW:	CMP #5,D0
	BNE.S NSPRAY
	MOVE.L #$463F0,A4
	BRA.S ICJN1
NSPRAY:	MOVE.L #$463C0,A4
	ASL #4,D0
	ADD D0,A4
ICJN1:	MOVE.L #$43B60,FLIPI 
ICJN:	MOVE.L A4,TARGETI
	MOVE.L ICONST,FLIPST
	MOVE #6,FLIPC
	CLR WAGNO
	MOVE.L #E2,D7
	BSR.L son
	CLR ICONNO
	MOVE.L #$79228,ICONST ;RESET TO START	
wiznsel:
wizret:RTS

CATELITE:
	MOVEM.L A0-A2,-(SP)
	TST.B ICAT
	BNE.L CATRET
	MOVE.B JOYPORT1,D7
	CMP #10,BUTTON
	BMI.S CATAUTO
	MOVE.B D7,D0
	AND.B #15,D0
	BEQ.S CATAUTO	
	MOVE X+2,D1
	MOVE Y+2,D2
	BTST #1,D7
	BEQ.S CATU
	CMP #150,D2
	BCC.S CATD
	ADDQ #4,D2
CATU:	BTST #0,D7
	BEQ.S CATD
	CMP #56,D2
	BCS.S CATD
	SUBQ #4,D2
CATD:	BTST #3,D7
	BEQ.S CATR
	MOVE #1,CFIREDRN
	CMP #284,D1
	BCC.S CATL
	ADDQ #4,D1
CATR:	BTST #2,D7
	BEQ.S CATL
	CLR CFIREDRN
	CMP #20,D1
	BCS.S CATL
	SUBQ #4,D1
CATL:	MOVE D1,X+2
	MOVE D2,Y+2
	BRA.S CATOK2

CATAUTO:MOVE FIREDRN,CFIREDRN
	MOVE Y+2,D0
	SUB Y,D0
	SUBQ #2,D0
	BEQ.S CATOK
	BMI.S CATUP
	LSR #2,D0
	ADDQ #1,D0
	SUB D0,Y+2
	BRA.S CATOK
CATUP: 	NEG D0
	LSR #2,D0
	ADDQ #1,D0
	ADD D0,Y+2

CATOK:	MOVE X+2,D0
	CMP #139,D0
	BCC.S CATC2
	ADDQ #4,X+2
	BRA.S CATOK2
CATC2:	CMP #182,D0
	BCS.S CATMOV
	SUBQ #4,X+2
	BRA.S CATOK2
CATMOV:	MOVE #140,D0
	TST FIREDRN
	BNE.S CATLEFT
	MOVE #180,D0
CATLEFT:CMP X+2,D0
	BEQ.S CATOK2
	BCC.S CATINC	 
	SUBQ #4,X+2
	BRA.S CATOK2
CATINC:	ADDQ #4,X+2
CATOK2:	MOVE #1,D0
	BSR.L prnt
	BTST #7,D7
	BEQ catnfire
	TST BULX+4
	BPL.S catnfire
catfire:MOVE Y+2,D0  
	ADD #5,D0
	CMP #138,D0
	BCC catnfire	
	MOVE D0,BULY+4
	CLR BULYD+4
	MOVE.L #E5,D7
	BSR.L son
	MOVE X+2,D0 ;catx
	ADDQ #6,D0
	MOVE D0,BULX+4
	MOVE #10,BULXD+4
	TST.B IFIRE
	BNE.L NCBIDI; NOT BI-DIRECTIONAL
	MOVE CLAST,D0
	EOR #1,D0
	MOVE D0,CLAST
	BNE.S catfnjn
	BRA.S catnfire
NCBIDI:	MOVE CFIREDRN,CLAST
	TST CFIREDRN
	BNE.S catnfire
catfnjn:NEG BULXD+4
catnfire:LEA X,A0
	MOVE #16,D2
	MOVE #7,D1
CATHITLP:MOVE.W 64(A0,D2.W),D6
	CMP #9,D6
	BCS CATHITNXT
	MOVE.W (A0,D2.W),D0
	SUB X+2,D0
	ADD #16,D0
	CMP #32,D0
	BCC CATHITNXT
	MOVE.W 32(A0,D2.W),D0
	SUB Y+2,D0
	ADD #16,D0
	CMP #22,D0
	BCC CATHITNXT
	MOVE D6,D0
	BSR BADHIT
	MOVE.W D0,64(A0,D2.W)	
	SUBQ #1,CATLIVES
	MOVE #E15,D7
	BSR son
	TST CATLIVES
	BNE CATHITNXT
	MOVE.B #1,ICAT
	MOVE #9,CATLIVES
CATHITNXT:ADDQ #2,D2	
	DBRA D1,CATHITLP
CATRET: MOVEM.L (SP)+,A0-A2
	RTS


FLIP: 	TST FLIPC ;FLIPS ICONS
	BEQ.S FLIPRET
	SUBQ #1,FLIPC
	CMP #2,FLIPC
	BCC.S FLIPPER	
	MOVE.L TARGETI,A4
	BRA.S FLIPJN
FLIPPER:ADD.L #$10,FLIPI
	MOVE.L FLIPI,A4
FLIPJN:	BSR.L IPRNT
FLIPRET:RTS

BACKLINE:CLR.L D0
	MOVE POSITION,D3
	ASR #1,D3
	MOVE D3,D2
	ASR #1,D2
	MOVE D2,D4
	MOVE.L #$40140,A0
	MOVE.L phys,A2
	ADD #$5828,A2 ;BACKGRND LINE IN A2
	MOVE #0,D1	
	BSR.S BACKSCROL
	MOVE D3,D2
	MOVE #1,D1
	BSR.S BACKSCROL
	ADD D4,D2
	MOVE #1,D1
	BSR.S BACKSCROL
	MOVE ROTATE,D2
	MOVE #2,D1
	BSR.S BACKSCROL
	ADD #$8C0,A2
	ADD #$820,A0

	ADD D3,D2
	MOVE #5,D1
	BSR.S BACKSCROL
	RTS

BACKSCROL:AND #15,D2
 CHRLP:	MOVE (A0),D6
	ROL D2,D6
	SWAP D6
	MOVE 2(A0),D7
	ROL D2,D7
	MOVE D7,D6
	MOVE.L #17,D0
 LINLP:	MOVE.L D6,(A2)+
	ADDQ #4,A2
	DBRA D0,LINLP

	LEA $10(A2),A2	
	LEA $A0(A0),A0
	DBRA D1,CHRLP
	RTS

CLEARPLAY:MOVE.L phys2,A0
	ADD #$6A40,A0
	MOVE #4096,D7
CLEARLP:MOVE.L #0,-(A0)
	DBRA D7,CLEARLP
	RTS	

replacer:LEA BACKS+64,A6
reploop:MOVE.L (A6)+,A0
	CMP.L #0,A0
	BMI.S repret
	MOVE #23,D4
	MOVE.L A0,D0
	AND.L #$7FFF,D0
	ADD.L #$38000,D0
	MOVE.L D0,A1
BHLOOP:	MOVE.L (A1),(A0)
	MOVE.L 8(A1),8(A0)
	MOVE.L 16(A1),16(A0)
	LEA $A0(A0),A0
	LEA $A0(A1),A1
	DBRA D4,BHLOOP

	BRA.S reploop

repret: RTS

replace:LEA BACKS+4,A6
replop:MOVE.L (A6)+,A0
	CMP.L #0,A0
	BMI.S repnxt
	MOVE #16,D4
	MOVE.L A0,D0
	AND.L #$7FFF,D0
	ADD.L #$38000,D0
	MOVE.L D0,A1
RPLOOP:	MOVE.L (A1)+,(A0)+
	MOVE.L (A1)+,(A0)+
	MOVE.L (A1)+,(A0)+
	MOVE.L (A1),(A0)
	LEA $94(A0),A0
	LEA $94(A1),A1
	DBRA D4,RpLOOP

repnxt:	CMP.L #BACKS+64,A6
	BCS.S replop
	RTS

rprnt:	CLR.L D0 
	MOVEM.L A0-A5/D0-D7,-(SP)
	LEA X,A3
	MOVE (A3),D6
	MOVE 32(A3),D7
	MOVE 64(A3),D0
	TST.W D0
	BMI.L rpret
	ASL #2,D0
	MOVE.L D0,A0
	ADD.L #SRCE,A0
	MOVE.L (A0),A1
	MOVE.L #1,D3; wid
	MOVE.L #199,D4; height
	BSR.L cord
	
;POKE SPRITE ONTO PLANES 0 & 1 AND POKE MASK ONTO PLANE 3 

YRPOT:	MOVE.W D3,D1   ;D3 WID
	MOVE.L A0,A3   ;A0 SCREEN
	MOVE.L A1,A4   ;A1 SPRITE
			;D4 HEI
XRPOT:	CLR.L D6
	MOVE (A4)+,D6	; spr
	ROR.L D0,D6
	MOVE.L D6,D5; COPY TO MASK
	OR D6,(A3)+
	SWAP D6
	OR D6,6(A3)

	CLR.L D6
	MOVE (A4)+,D6	; spr
	ROR.L D0,D6
	OR.L D6,D5; ADD TO MASK
	OR D6,(A3)+
	SWAP D6
	OR D6,6(A3)

	CLR.L D6
	MOVE (A4)+,D6	; spr
	ROR.L D0,D6
	OR.L D5,D6; ADD OTHERS TO FORM COMBINED MASK
	OR D6,(A3)+	
	SWAP D6
	OR D6,6(A3)

	ADDQ #2,A3
	ADDQ #2,A4

	DBRA D1,XRPOT
	LEA $A0(A0),A0
	LEA $A0(A1),A1
	DBRA D4,YRPOT

rpret2:	MOVEM.L (SP)+,D0-D7/A0-A5
	RTS
rpret:  MOVE.L #$FFFFFFFF,(A4) 
	BRA.S rpret2


wizprnt:CMP #14,TUBECNT
	BCC wprret
	MOVE C,D0
	TST.W D0
	BMI.L wprret
	ASL #2,D0
	LEA SRCE,A0
	ADD D0,A0
	MOVE.L (A0),A1
	MOVE.L MASK-SRCE(A0),A2
	MOVE.L BACKS,A0
	MOVE.L DETECT3,D0
	CMP.L $500(A0),D0
	BEQ.S NOCOLLISION
COLLISION:MOVE OPOSITION,POSITION
	MOVE OHEIGHT,HEIGHT
	MOVE OY,Y
	TST.B ITHRUST
	BNE.S NHOVER
	CLR SPINLO
	CLR OSPINLO
	CLR SPIN
	BRA.S HOVJN
NHOVER:	NEG SPINLO
	NEG SPIN
 HOVJN:	MOVE SPIN,SPEED
	BRA.L NOCOLLISION2
NOCOLLISION:MOVE.L (A0),D0
	MOVE.L DETECT1,D1
	EOR.L D1,D0
	AND.L #$3C003C0,D0
	BNE.S COLLISION2
	MOVE.L $960(A0),D0
	MOVE.L DETECT5,D1
	EOR.L D1,D0
	AND.L #$3C003C0,D0
	BEQ.L NOCOLLISION2
COLLISION2:TST YDRCT
	BLE NHOLE
	MOVE POSITION,D2
	AND #31,D2
	CMP #27,D2
	BCC NHOLE
	CMP #21,D2
	BCS NHOLE
	MOVE.W READER,D2
	MOVE.L MAPREAD,A6
	MOVE Y,D0
	SUB #51,D0
YFI:	ADDQ #1,D2
	SUB #24,D0
	BPL YFI
	MOVE.B 19(A6,D2.W),D1
	BPL NHOLE
	MOVE #2,FIN
NHOLE:	MOVE OHEIGHT,HEIGHT
	MOVE OY,Y
	TST.B ITHRUST
	BNE.S NHOVER2
	CLR YDRCT
	MOVE POSITION,OPOSITION
	BRA.S HOVJN2
NHOVER2:NEG YDRCT
HOVJN2:	MOVE SPIN,SPEED

NOCOLLISION2:MOVE.L #14,D4
	MOVE.L D4,BACKH
	BSR.L CATELITE
	BSR.L DIRECT
	TST BUTTON
	BEQ.S wprret2
	CMP.B #2,IFIRE
	BEQ.S wprret2
	MOVE.L SRCE+132,A1
	MOVE.L MASK+132,A2
	MOVE #10,D4
	BSR.S DIRECT
	SUB.L #$1720,A0
	MOVE.L SRCE+128,A1
	MOVE.L MASK+128,A2
	MOVE #10,D4
	CMP #62,Y
	BCC NOVERLAP
	MOVE #62,D0
	SUB Y,D0
OVERLOOP:LEA $A0(A0),A0	
	LEA $A0(A1),A1	
	LEA $A0(A2),A2	
	SUBQ #1,D4
	DBRA D0,OVERLOOP
NOVERLAP:MOVE.L A0,BACKS
	BSR.S DIRECT
	MOVE.L #36,BACKH
wprret2:RTS
wprret: MOVE.L #-1,BACKS 
	BRA.S wprret2

DIRECT:	MOVE.L (A2)+,D0
	EOR.L #-1,d0
	MOVE.L (A0),D1
	AND.L D0,D1
	OR.L (A1)+,D1
	MOVE.L D1,(A0)+

	MOVE.L (A0),D1
	AND.L D0,D1
	OR.L (A1),D1
	MOVE.L D1,(A0)
	
	LEA $9c(A0),A0
	LEA $9c(A1),A1
	LEA $9c(A2),A2
	DBRA D4,DIRECT
	RTS

wizreplace:MOVE.L BACKS,A0
	CMP.L #0,A0
	BMI.S repret0
	MOVE.L A0,D0
	AND.L #$7FFF,D0
	ADD.L #$38000,D0
	MOVE.L D0,A1
	MOVE.L BACKH,D4
RHLOOP:	MOVE.L (A1)+,(A0)+
	MOVE.L (A1),(A0)
	LEA $9C(A0),A0
	LEA $9C(A1),A1
	DBRA D4,RHLOOP
repret0:RTS
	

prnt0: CLR.L D0
prnt:
setup: 
	MOVEM.L A0-A5/D0-D7,-(SP)
	AND.L #255,D0
	ASL #1,D0
	MOVE.L D0,A3
	ADD.L #X,A3
	ASL #1,D0
	MOVE D0,A4
	ADD.L #BACKS,A4
	MOVE (A3),D6
	MOVE 32(A3),D7
	MOVE 64(A3),D0
	TST.W D0
	BMI.L prret
	ASL #2,D0
	MOVE.L D0,A0
	ADD.L #SRCE,A0
	MOVE.L (A0),A1
	MOVE.L WID-SRCE(A0),D3
	MOVE.L D3,128(A4)
	LSR.B #2,D3
	MOVE.L HEI-SRCE(A0),D4
	MOVE.L D4,256(A4)
	MOVE.L MASK-SRCE(A0),A2
	BSR.L cord
	MOVE.L A0,(A4)

rotpoke: 
YROT:	MOVE.W D3,D1   ;D3 WID
	MOVE.L A0,A3   ;A0 SCREEN
	MOVE.L A1,A4   ;A1 SPRITE
	MOVE.L A2,A5   ;A2 MASK
			;D4 HEI
XROT:	CLR.L D7
	MOVE (A5),D7	; mask
	EOR.L #-1,D7
	ROR.L D0,D7
	MOVE.L D7,D2; D2=OTHER HALF OF MASK
	SWAP D2

	CLR.L D6
	MOVE (A4)+,D6	; spr
	ROR.L D0,D6
	AND D7,(A3)
	OR D6,(A3)+
	SWAP D6
	AND D2,6(A3)
	OR D6,6(A3)

	CLR.L D6
	MOVE (A4)+,D6	; spr
	ROR.L D0,D6
	AND D7,(A3)
	OR D6,(A3)+
	SWAP D6
	AND D2,6(A3)
	OR D6,6(A3)

	CLR.L D6
	MOVE (A4)+,D6	; spr
	ROR.L D0,D6
	AND D7,(A3)
	OR D6,(A3)+
	SWAP D6
	AND D2,6(A3)
	OR D6,6(A3)

	CLR.L D6
	MOVE (A4)+,D6	
	ROR.L D0,D6
	AND D7,(A3)
	OR D6,(A3)+
	SWAP D6
	AND D2,6(A3)
	OR D6,6(A3)

	ADDQ #8,A5
	DBRA D1,XROT
	LEA $A0(A0),A0
	LEA $A0(A1),A1
	LEA $A0(A2),A2
	DBRA D4,YROT
	MOVEM.L (SP)+,D0-D7/A0-A5
	RTS
	prret: MOVE.L #$FFFFFFFF,(A4) 
	prret2:
	MOVEM.L (SP)+,A0-A5/D0-D7
	RTS


res:	MOVE.L #E14,D7
	BSR.L son
	CLR D6
reslp:	BSR.S dres
	ADDQ #1,D6
	CMP #4,d6
	BCS.S reslp
	RTS
deres:	MOVE.L #E13,D7
	BSR.L son
	MOVE #3,D6 
drlp:	BSR.S dres
	SUBQ #1,d6
	BPL DRLP
	RTS
dres:	MOVE D6,D2
	ASL #1,D2
	LEA DMASK,A0
	MOVE (A0,D2.W),D7; MASK
	BSR.L swapscrn
	MOVE.L #1,D3
	ASL D6,D3; VERTICAL COPIES 
	ASL #1,D3
	SUBQ #1,D3
	MOVE.L #$38000,A0; FROM
	MOVE.L phys,A1; TO
vertlp:	MOVE #$4F,D4 ;LINE LENGTH	
	MOVE.L A1,A2; COPY OF TO
DERLP:	MOVE (A0)+,D1
	AND D7,D1
	BEQ.S NDRT
	MOVE #1,D5; START ROT
	MOVE D6,D2

DRTLP:	MOVE D1,D0

' ***************************
' * More corruption was here .. need to replace with Easyrider listing
' ***************************

	asl.w	d5,d1
	add.w	d0,d1
	asl.w	#1,d5
	dbf	d2,DRTLP
l01e8
	move.w	d1,(a1)+
	dbf	d4,DERLP
	move.w	d3,d2
l01e9
	move.w	#$4f,d4
l01ea
	move.w	(a2)+,(a1)+
	dbf	d4,l01ea
	lea	$a0(a0),a0
	dbf	d2,l01e9

' In the original source, DBRA was used instead of DBF 
'	LEA $A0(A0),A0
'	DBRA D2,VLOP2

	CMP.l #$3FB00,A0
	BCS.S vertlp	
	BSR.L setscrn
	BSr.L owvbl
	BSr.L owvbl
	RTS

BULLETS:LEA BULX,A2
	LEA X,A1
	LEA BULA,A3
	LEA BULR,A4
BULLP:	MOVE (A2),D6 ;X
	TST D6
	BMI.S BULNXT
	MOVE 16(A2),D7 ;Y
	ADD 32(A2),D6 ;+XDRCT
	CMP #300,D6
	BCC.S BULDED
	ADD 48(A2),D7 ;+YDRCT
	CMP #138,D7
	BCC.S BULDED
	MOVE D6,(A2)
	MOVE D7,16(A2)
	
	MOVE #7,D2
	MOVE #16,D1
BADCHK:	TST 64(A1,D1.W)
	BEQ.S BADNXT
	MOVE (A1,D1.W),D0
	SUB D6,D0
	ADD #16,D0
	CMP #20,D0
	BCC.S BADNXT	
	MOVE 32(A1,D1.W),D0
	SUB D7,D0
	ADD #14,D0
	CMP #18,D0
	BCS.S BADBULD
BADNXT:	ADDQ #2,D1
	DBRA D2,BADCHK
	BSR.L cord
	MOVE.L A0,(A3); BULA
	MOVE.L (A0),32(A3); BULC
	MOVE D0,(A4);BULR
BULNXT:	ADDQ #4,A3
	ADDQ #2,A4
	ADDQ #2,A2
	CMP.L #BULX+6,A2
	BCS.S BULLP
	RTS

BADBULD:MOVE.W 64(A1,D1.W),D0
	BSR BADHIT
	MOVE D0,64(A1,D1.W)
BULDED: MOVE #-1,(A2)
	MOVE.L #-1,(A3)
	BRA.S BULNXT

BADHIT:	CMP.W #9,D0
	BEQ.S POD
	BCS.S BADHRET 
	CLR.W D0	
	BRA.S BADHRET
POD:	MOVE.W #8,D0
BADHRET:RTS

bprnt:	LEA BULA,A0
	LEA BULR,A2
	LEA BBACK,A3
	LEA BULX,A4
BPLP:	MOVE.L (A0),A1
	CMP.L #0,A1
	BMI.S BPNXT 
	MOVE (A2),D0
	MOVE.L #$FF000000,D3
	LSR.L D0,D3
				
	SWAP D3
	MOVE.L 32(A0),D1 ;BULC	
	MOVE.L (A1),D2
	EOR.L D2,D1
	AND.W D3,D1
	BNE.S BULDED2
	SWAP D1
	AND.W D3,D1
	BNE.S BULDED2

	ADDQ.L #6,A1
	MOVE.L A1,(A3) ;BBACK
	MOVE (A1),D1
	OR D3,D1
	MOVE D1,(A1)
	MOVE $A0(A1),D1
	OR D3,D1
	MOVE D1,$A0(A1)
	SWAP D3
	MOVE 8(A1),D1
	OR D3,D1
	MOVE D1,8(A1)
	MOVE $A8(A1),D1
	OR D3,D1
	MOVE D1,$A8(A1)
	BRA.S BPNXT
BULDED2:MOVE.L #-1,(A0)
	MOVE #-1,(A4)		
BPNXT:	ADDQ.L #2,A2
	ADDQ.L #2,A4
	ADDQ.L #4,A0	
	ADDQ.L #4,A3
	CMP.L #BULA+16,A0
	BCS.S BPLP

ZAPPER: CMP.L #14,BACKH
	BEQ.S ZAPRET
	LEA X,A1
	MOVE #7,D2
	MOVE #16,D1
ZAPCHK:	TST 64(A1,D1.W) ;BAD C
	BEQ.S ZAPNXT
	MOVE (A1,D1.W),D0 ;BAD X
	SUB #144,D0
	CMP #32,D0
	BCC.S ZAPNXT	
	MOVE 32(A1,D1.W),D0; BAD Y
	SUB Y,D0
	BMI.S ABOVE
	SUB #15,D0
	CMP #11,D0	
	BCC.S ZAPNXT
	BRA.S BADZAP
ABOVE:	ADD #26,D0
	BCC.S ZAPNXT
BADZAP:	MOVE.W 64(A1,D1.W),D0
	CMP.W #9,D0
	BEQ.S ZPOD
	BCS.S ZAPNXT 
	CLR.W 64(A1,D1.W)	
	BRA.S ZAPNXT
ZPOD:	MOVE.W #8,64(A1,D1.W)

ZAPNXT:	ADDQ #2,D1
	DBRA D2,ZAPCHK
ZAPRET:	RTS

breplace:LEA BBACK,A0
BRLP:	MOVE.L (A0),D1
	MOVE.L D1,A2
	TST.L D1
	BMI.S brnxt
	AND.L #$7FFF,D1
	ADD.L #$38000,D1
	MOVE.L D1,A1
	MOVE (A1),(A2)
	MOVE 8(A1),8(A2)
	MOVE $A0(A1),$A0(A2)
	MOVE $A8(A1),$A8(A2)
brnxt:	ADDQ.L #4,A0
	CMP.L #BBACK+32,A0
	BCS.S BRLP
	RTS

INITPHYS:MOVE.L #$78000,phys
	MOVE.L #$70000,phys2
	BRA.L SETSCRN

dark:	LEA ZEROS,A0
	BRA.S PALJZ
colour:	LEA TITCOL,A0
	BRA.S PALJZ
grey:	LEA GREYCOL,A0
	BRA.S PALJZ
light: 	LEA palette,A0
PALJZ:	LEA PALREG,A1
	MOVE #$F,D0
PALJN:	MOVE.W (A0)+,(A1)+
	DBRA D0,PALJN
	RTS

FADEIN:	MOVE #6,D6
	MOVE.L A1,A2
FADEIN1:LEA PALREG+2,A0; TARGET IN A1
	MOVE #14,D7
FADEIN2:BSR.L MODIFY
	ADDQ #2,A0
	ADDQ #2,A1
	DBRA D7,FADEIN2
	MOVE #4,D0
	BSR.L WAIT
	MOVE.L A2,A1
	DBRA D6,FADEIN1
	RTS

randsub:
	MOVE.L D1,-(SP)
	TST.L RANVAL
	BNE.S NZRAN
	MOVE.L $4BA,D0
	MOVE.L #16,D1
	ASL.L D1,D0
	OR.L $4BA,D0
	MOVE.L D0,RANVAL
NZRAN:	MOVE.L #$BB40E62D,D0
	MOVE.L RANVAL,D1
	MULU D0,D1
	MOVE.L D1,RANVAL
	ASR.L #8,D1
	AND.L #$FFF,D1
	MOVE.L D1,D0
	MOVE.L (SP)+,D1
	RTS

inkey:	MOVE.W #$FF,-(SP)
	MOVE.W #6,-(SP)
	TRAP #1
	ADDQ.L #4,SP
	RTS

initjoy:MOVE #$14,-(SP)
	MOVE #4,-(SP)
	MOVE #3,-(SP)
	TRAP #13
	ADDQ.L #6,SP
	
	MOVE #34,-(SP)
	TRAP #14
	ADDQ.L #2,SP
	MOVE.L D0,A0
	ADD.L #24,A0
	LEA OJOYVECT,A1
	MOVE.L (A0),(A1)
	LEA joyevent,A1
	MOVE.L A1,(A0)
	CLR.B JOYPORT0
	CLR.B JOYPORT1
	RTS

joyevent:MOVEM.L A0/A1,-(SP)
	LEA joyport0,A1
	MOVE.B (A1),D0
	MOVE.B 1(A0),(A1)
	MOVE.B 1(A1),D1
	MOVE.B 2(A0),1(A1)
	EOR.B D1,D0
	AND #12,D0
	BEQ.S NOWAG
	CMP #4,WAGCNT
	BCC.S WAGRESET
	ADDQ #1,WAGNO	
	BRA.S WAGRST
WAGRESET:CLR WAGNO
WAGRST:	CLR WAGCNT
NOWAG:	MOVEM.L (SP)+,A0/A1
	RTS

resmouse:MOVE #34,-(SP)
	TRAP #14
	ADDQ.L #2,SP
	MOVE.L D0,A0
	ADD.L #24,A0
	MOVE.L OJOYVECT,(A0)

	MOVE #128,-(SP)
	MOVE #4,-(SP)
	MOVE #3,-(SP)
	TRAP #13
	ADDQ.L #6,SP
	
	MOVE #1,-(SP)
	MOVE #4,-(SP)
	MOVE #3,-(SP)
	TRAP #13
	ADDQ.L #6,SP
	RTS


cord:	MOVE D6,D0
	AND #15,D0
	AND #$FFF0,D6
	ASR #1,D6
	ASL #5,D7
	MOVE.L phys,A0
	ADD D7,A0
	ASL #2,D7
	ADD D7,A0
	ADD D6,A0
	RTS


initscrn:MOVE.L #$78000,phys
	MOVE.l #$70000,phys2
csetscrn:MOVE.W #0,-(SP)
	MOVE.L phys,-(SP)
	MOVE.L phys,-(SP)
	MOVE #5,-(SP)
	TRAP #14
	ADD.L #12,SP
	RTS

H:	MOVEM.L A0-A6/D0-D7,-(SP)
	MOVE.W #1,-(SP)
	move.l #$78000,-(sp)
	move.l #$78000,-(sp)
	move #5,-(sp)
	trap #14
	add.l #12,sp
	MOVE.W #$000,PALREG+6
	MOVE.W #$666,PALREG
	MOVE.B #7,$484
	BSR INTOFF
	MOVEM.L (SP)+,A0-A6/D0-D7
	RTS 

swapscrn:MOVE.L phys,D0

' in the final game, this line has been changed to: eori.l	#$8000,d0
	MOVE.L phys2,phys

	MOVE.L D0,phys2
	MOVE #95,D0
	LEA BACKS,A0  ;swap replace data
	LEA BACKCOP,A1
BACKERLP:MOVE.L (A1),D1
	MOVE.L (A0),(A1)+

***************

' There was some corruption on the disk so this section needs re-doing via an Easyrider dump

'	MOVE.81B`BH
E,p3@@±h8Bڂ;5L^ A4B dnH^^9kL:	

	move.l	d1,(a0)+
	dbf	d0,BACKERLP
	move.w	#7,d0
	lea	$58cd6,a0          ' not sure where these are pointing to at the moment
	lea	$58cf6,a1          '
BBACKL
***************

	MOVE.L (A1),D1
	MOVE.L (A0),(A1)+
	MOVE.L D1,(A0)+
	DBRA D0,BBACKL
	RTS

ss:	move.l #$48000,phys
	MOVE.B #0,$FF8260

setscrn:MOVE.B phys+2,$FF8203
	MOVE.B phys+1,$FF8201
	RTS

WAIT:	BSR.S owvbl
	DBRA D0,WAIT
	RTS

owvbl:	MOVEM.L D0-D2/A0-A2,-(SP)
	MOVE.W #37,-(sp)
	TRAP #14
	ADDQ.L #2,SP
	MOVEM.L (SP)+,D0-D2/A0-A2
	RTS

wvbl:	CMP #2,SYNC
	BLT.S wvbl
	CLR SYNC
	RTS

interrupt:;ADDQ #1,PALREG+10
	;addq #1,palreg+18
;	CLR.W PALREG
	ADDQ #1,SYNC
CONIN:	JMP $FFFFFFFF

event:  ADDQ.W #1,PALREG
	RTS

SETINT:	MOVE.L VECTOR,D0
	BNE.S SETINT2
	MOVE.L $70,VECTOR
SETINT2:MOVE.L VECTOR,CONIN+2 ;set return vector at end of new routine
	MOVE.L #INTERRUPT,$70 ;redirect vector to new routine
	MOVE.L #EVENT,$78
	MOVE.B #3,$FFFA21
	MOVE.B #8,$FFFA19; OP MODE
	BSET #0,$FFFA07
	RTS

INTOFF: MOVE.L VECTOR,$70 ;replace old vector address (UNTRIED)
;	MOVE.W #8,-(SP); TIMER B
;	MOVE.W #26,-(SP); jdisint p.189
;	TRAP #14 ; SWITCH OFF TIMER
;	ADDQ.L #4,SP
	RTS

score:	MOVE #1,D0
scorev:	ADD.B (A0),D0
	MOVE.B D0,(A0)
	CMP #58,D0
	BCS SCRET
	SUB.B #10,D0
	MOVE.B D0,(A0)
	SUBQ.L #1,A0
	BRA score
SCRET:	CMP.L #player1+2,A0
	BNE SCRET2
	SUBQ.B #1,XTR
	BGT SCRET2
	MOVE.B #5,XTR
	ADDQ.B #1,LIVES
SCRET2:	MOVE #3,SCORFLG
	RTS

scoreset:MOVE #3,SCORFLG
scorstlp:BSR scoreprnt
	SUBQ #1,SCORFLG
	BNE SCORSTLP
	RTS
scoreprnt:TST SCORFLG
	BEQ SCORET
	CMP #3,SCORFLG
	BNE SCOREPRNT2
	MOVE.L phys,-(SP)
	MOVE.L #$38000,phys ;print to background
	MOVE #0,X+12
	MOVE #42,Y+12
	MOVE #39,C+12
	MOVE.L #player1+1,A4
	BSR.L numbers
	MOVE.L #-1,BACKS+24 ;PREVENT REPLACEMENT
	SUBQ #1,SCORFLG
	MOVE.L (SP)+,phys
SCORET:	RTS

SCOREPRNT2:LEA $39A40,A0 ;copies from background
	MOVE.L phys,A1
	LEA $1A40(A1),A1
	MOVE #6,D0
SCORLP:	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0),(A1)
	LEA $8C(A0),A0
	LEA $8C(A1),A1
	DBRA D0,SCORLP
	RTS

numbers:;A4 HOLDS STRING
numlp:	CLR.L D0
	MOVE.B (A4)+,D0
	TST.B D0
	BEQ.S numex
	BSR.L numprnt
	BRA.S numlp
numex: 	RTS

numprnt:SUB #48,D0
	ASL.W #3,D0
	ADD.L #$28000,D0
	MOVE.L D0,SRCE+156
	MOVE #6,D0
	BSR.L prnt
	ADDQ.W #8,X+12
	RTS


super:	CLR.L -(SP)
	MOVE.W #$20,-(SP)
	TRAP #1
	ADDQ.L #6,SP
	MOVE.L D0,SVSP
	RTS

unsuper:MOVE.L SVSP,-(SP)
	MOVE.W #$20,-(SP)
	TRAP #1
	ADD.L #6,SP
	RTS	

sclr:	MOVE.L #$78000,A0
	MOVE.L #$7000,D0
 SCLRLP:MOVE.L #0,(A0)+
	DBRA D0,SCLRLP
	RTS

son:	MOVEM.L A0-A2/D0-D2,-(SP)
	MOVE.L D7,A0
	TST.B PRIORTIM
	BEQ.S SONOK 
	MOVE.B PRIORITY,D0
	CMP.B (A0),D0	
	BCC.S SONRET
 SONOK:	MOVE.B (A0),PRIORITY
	MOVE.B 1(A0),PRIORTIM
	ADDQ.L #2,D7
	MOVE.L D7,-(SP)
	MOVE.W #32,-(SP)
	TRAP #14
	ADDQ.L #6,SP
 SONRET:MOVEM.L (SP)+,A0-A2/D0-D2
	RTS


wayter:	MOVE.L D0,-(SP)
	BSR.L wvbl
	MOVE.L (SP)+,D0
	DBRA D0,wayter
	RTS

L:	MOVE.L #F1,A0
	BSR.S LOAD
	MOVE.L #F2,A0
	BSR.S LOAD
	MOVE.L #F3,A0
	BSR.S LOAD
	MOVE.L #TITLEPIC,A0
	BSR.S LOAD
	MOVE.L #WBACKS,A0
	BSR.S LOAD
	MOVE.L #TEXT/<$$$$$$$.S LOAD
	MOVE SR,D0
	CMP #$22FF,D0
	BGT.S OKSUP2
	BSR.L super
OKSUP2:	MOVE.L $70,VECTOR
	RTS
	
LOAD:	;A0=FILENAME
	MOVE.L (A0)+,LADD
	MOVE #2,-(SP)
	MOVE.L A0,-(SP)
	MOVE #$3D,-(SP)
	TRAP #1
	ADDQ.L #8,SP
	TST.W D0
	BMI.S OUCH
	MOVE D0,HANDLE

	MOVE.L LADD,-(SP)
	MOVE.L #32128,-(SP)
	MOVE D0,-(SP)
	MOVE #$3F,-(SP)
	TRAP #1
	ADD.L #12,SP
	TST.L D0
	BMI.S OUCH

	MOVE.W HANDLE,-(SP)
	MOVE #$3E,-(SP)
	TRAP #1
	ADDQ.L #4,SP
	TST.W D0
	BMI.S OUCH
	RTS

OUCH:	NEG.L D0
	ILLEGAL
HANDLE:	DC.W 0
LADD:	DC.L 0

F1:	DC.L $38000-34
	DC "wiz.pi1",0
EVEN
F2:	DC.L $40000-34
	DC "wizsprit.pi1",0
EVEN
F3:	DC.L $48000-34
	DC "wizobj.pi1",0
EVEN
TITLEPIC:DC.L $50000-34
	DC"WIZTIT.PI1",0
EVEN
WBACKS:DC.L $30000-34
	DC"WBACKS.PI1",0
EVEN
TEXT:DC.L $28000-34
	DC"TEXT.PI1",0
even
eror:	illegal
